/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge;

import com.ibm.hwmca.fw.HException;

public class NativeBridgeException
extends HException {
    public static final int XPCE_NO_ERROR = 0;
    public static final int XPCE_COMP_RC_ADDR_ERR = 1;
    public static final int XPCE_COMPONENT_RC_SET = 2;
    public static final int XPCE_MESSAGE_ISSUED = 4;
    public static final int XPCE_LOG_ISSUED = 8;
    public static final int XPCE_MESSAGE_AND_LOG = 12;
    public static final int SUCCESS = 0;
    public static final int ERROR_NO_SUCH_OBJECT_NAME = 1;
    public static final int ERROR_NO_SUCH_FIELD_NAME = 2;
    public static final int ERROR_NO_SUCH_METHOD_NAME = 3;
    public static final int ERROR_ILLEGAL_ACCESS = 4;
    public static final int ERROR_INVOCATION_TARGET_EXCEPTION = 5;
    public static final int ERROR_METHOD_HAS_WRONG_RETURN_TYPE = 6;
    public static final int ERROR_NO_SUCH_CLASS = 7;
    public static final int ERROR_METHOD_IS_STATIC = 8;
    public static final int ERROR_METHOD_IS_NOT_STATIC = 9;
    public static final int ERROR_ARRAY_IS_OF_WRONG_TYPE = 10;
    public static final int ERROR_ILLEGAL_SIGNATURE_STRING = 11;
    public static final int ERROR_OBJECT_IS_NOT_A_STRING = 12;
    public static final int ERROR_OBJECT_IS_NOT_ARRAY = 13;
    public static final int ERROR_ARRAY_INDEX_OUT_OF_BOUNDS = 14;
    public static final int ERROR_IN_SYSTEM_CALL = 20;
    public static final int ERROR_INTERNAL = 21;
    public static final int ERROR_IN_NATIVE_FUNCTION = 22;
    public static final int ERROR_NATIVE_FUNCTION_DIDNT_FOLLOW_PROTOCOL = 23;
    public static final int ERROR_INVALID_ARGUMENT = 24;
    public static final int ERROR_OUT_OF_MEMORY = 25;
    public static final int ERROR_DEREFERENCING_NULL_OBJECT = 26;
    public static final int ERROR_INVALID_STATE = 27;
    public static final int ERROR_BRIDGE_CLOSED = 28;
    int errorCode;
    int systemReturnCode = 0;
    int componentReturnCode;
    boolean systemAndComponentReturnCodesValid;

    public NativeBridgeException(int errorCode, String text) {
        super(text);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getSystemReturnCode() {
        if (!this.systemAndComponentReturnCodesValid) {
            throw new IllegalStateException("Return codes not set");
        }
        return this.systemReturnCode;
    }

    public int getComponentReturnCode() {
        if (!this.systemAndComponentReturnCodesValid) {
            throw new IllegalStateException("Return codes not set");
        }
        return this.componentReturnCode;
    }

    public boolean areReturnCodesSet() {
        return this.systemAndComponentReturnCodesValid;
    }

    public void setSystemAndComponentReturnCodes(int systemReturnCode, int componentReturnCode) {
        this.systemReturnCode = systemReturnCode;
        this.componentReturnCode = componentReturnCode;
        this.systemAndComponentReturnCodesValid = true;
        this.setLogged(systemReturnCode == 8 || systemReturnCode == 12);
    }
}

